# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

from fairseq import file_utils
from fairseq.data.encoders import register_bpe, register_tokenizer, register_tagger


@register_bpe('identity')
@register_tokenizer('identity')
@register_tagger('identity')
class Identity(object):

    def __init__(self, args):
        self.train = True

    def encode(self, x: str, *args, **kwargs) -> str:
        return x

    def decode(self, x: str, *args, **kwargs) -> str:
        return x
