# Beyond Routing and Cascading: Introducing Cascade Routing for Cost-Effective LLMs
This repository contains the code for our paper "Beyond Routing and Cascading: Introducing Cascade Routing for Cost-Effective LLMs". In this README, we explain how to reproduce the results from the paper.

## Installation

To install the package, run the following commands in this folder, which assume that [Conda](https://anaconda.org/anaconda/conda) is installed on your machine.

```bash
conda create -n selection python=3.11
conda activate selection
python -m pip install -e .
```

Furthermore, to exactly reproduce our results, also run the following command:

```bash
python -m pip install -r requirements.txt
```

## Reproducing Results

First, obtain a Together API key and add it to the environment variables:

```bash
export TOGETHER_API_KEY="YOUR KEY"
```

Then, run:
```bash
bash scripts/main.sh
```

This script runs inference on several models, preprocesses and download some data, and run all of our experiments in the paper. Our code assumes that you have sufficient CPU cores available (at least 50). It will run for a day or two and spend around 100 USD on Together.

Once this script has finished, you can run the notebook `notebooks/postprocess.ipynb` to process the raw results and obtain the results mentioned in the paper. Note that our raw results were included in the submission material. Therefore, you can run this notebook without running the main script and obtain the results from the paper.