"""
    3rd Party Libraries
"""
import numpy as np


def log_sum_exp(x):
    """
        Compute log(sum(exp(x))) in a numerically stable way.
        
        Args:
            x (np.ndarray): Input array
            
        Returns:
            float: log(sum(exp(x)))
    """
    max_x = np.max(x)
    return max_x + np.log(np.sum(np.exp(x - max_x)))
