import pandas as pd
import torch
from sklearn.metrics import log_loss, roc_auc_score
from sklearn.model_selection import train_test_split
from sklearn.preprocessing import LabelEncoder, MinMaxScaler

from deepctr_torch.inputs import SparseFeat, DenseFeat, get_feature_names
from deepctr_torch.models import *

import numpy as np

training_name = "criteo_BN_dropout_01"

if __name__ == "__main__":
    # data = pd.read_csv('./data/criteo_sample.txt')
    
    col_names = ['label']
    col_names += ['I' + str(i) for i in range(1, 14)]
    col_names += ['C' + str(i) for i in range(1, 27)]
    data = pd.read_csv('./data/train_15M_rand.txt', delimiter='\t', names=col_names)

    sparse_features = ['C' + str(i) for i in range(1, 27)]
    # sparse_features = ['C' + str(i) for i in range(1, 26)]
    # dense_features = ['I' + str(i) for i in range(1, 13)]
    dense_features = ['I' + str(i) for i in range(1, 14)]

    data[sparse_features] = data[sparse_features].fillna('-1', )
    data[dense_features] = data[dense_features].fillna(0, )
    target = ['label']

    # 1.Label Encoding for sparse features, and do simple Transformation for dense features
    for feat in sparse_features:
        lbe = LabelEncoder()
        data[feat] = lbe.fit_transform(data[feat])
    mms = MinMaxScaler(feature_range=(0, 1))
    data[dense_features] = mms.fit_transform(data[dense_features])

    # 2.count #unique features for each sparse field, and record dense feature field name

    fixlen_feature_columns = [SparseFeat(feat, data[feat].nunique())
                              for feat in sparse_features] + [DenseFeat(feat, 1, )
                                                              for feat in dense_features]

    dnn_feature_columns = fixlen_feature_columns
    linear_feature_columns = fixlen_feature_columns

    feature_names = get_feature_names(
        linear_feature_columns + dnn_feature_columns)

    # 3.generate input data for model

    # train, test = train_test_split(data, test_size=0.2)
    
    sample_size = len(data)
    test_index = np.loadtxt("./data/test_index_10M.txt", dtype ='int')
    train_index = np.array(sorted(set(range(sample_size)) -  set(test_index)))

    train = data.iloc[train_index.tolist()]
    test = data.iloc[test_index.tolist()]
    
    
    for dropout_ratio in [0.1]:
        for seed in range(3, 60):
            num_train = len(train)
            random_shuffle = np.random.permutation(num_train)
            train_model_input = {name: train[name].iloc[random_shuffle] for name in feature_names}
            # train_model_input = {name: train[name] for name in feature_names}
            test_model_input = {name: test[name] for name in feature_names}

            # 4.Define Model, train, predict and evaluate

            device = 'cpu'
            use_cuda = True
            if use_cuda and torch.cuda.is_available():
                print('cuda ready...')
                device = 'cuda:0'

            model = xDeepFM(
                linear_feature_columns=linear_feature_columns, 
                dnn_feature_columns=dnn_feature_columns,
                task='binary',
                l2_reg_linear=0.0,
                l2_reg_embedding=0.0,
                device=device,
                seed=seed,
                dnn_dropout=dropout_ratio,
                dnn_use_bn=True,
                dnn_hidden_units=(512, 256, 128), # baseline arch
                cin_layer_size=(256, 256), # baseline arch
                # dnn_hidden_units=(256, 128, 64), # small arch
                # cin_layer_size=(128, 128), # small arch
                # dnn_hidden_units=(128, 64, 32), # smaller arch
                # cin_layer_size=(64, 64), # smaller arch
            )
            
            # if model_type == "DCN":
            #     model = DCN(
            #         linear_feature_columns=linear_feature_columns, 
            #         dnn_feature_columns=dnn_feature_columns,
            #         task='binary',
            #         l2_reg_linear=0.0,
            #         l2_reg_embedding=0.0,
            #         device=device,
            #         seed=seed,
            #         dnn_dropout=0,
            #         dnn_use_bn=True,
            #         dnn_hidden_units=(512, 256, 128), # baseline arch
            #     )
            
            # if model_type == "DCNMix":
            #     model = DCNMix(
            #         linear_feature_columns=linear_feature_columns, 
            #         dnn_feature_columns=dnn_feature_columns,
            #         task='binary',
            #         l2_reg_linear=0.0,
            #         l2_reg_embedding=0.0,
            #         device=device,
            #         seed=seed,
            #         dnn_dropout=0,
            #         dnn_use_bn=True,
            #         dnn_hidden_units=(512, 256, 128), # baseline arch
            #     )
            # if model_type == "DeepFM":
            #     model = DeepFM(
            #         linear_feature_columns=linear_feature_columns, 
            #         dnn_feature_columns=dnn_feature_columns,
            #         task='binary',
            #         l2_reg_linear=0.0,
            #         l2_reg_embedding=0.0,
            #         device=device,
            #         seed=seed,
            #         dnn_dropout=0,
            #         dnn_use_bn=True,
            #         dnn_hidden_units=(512, 256, 128), # baseline arch
            #     )

            model.compile(
                "adagrad", 
                "binary_crossentropy",
                metrics=["binary_crossentropy", "auc"],
            )
            model.fit(
                train_model_input,
                train[target].iloc[random_shuffle].values,
                batch_size=1024,
                epochs=1,
                verbose=1,
                validation_split=0.0,
            )

            pred_ans = model.predict(test_model_input, 1024)
            y = test[target].values
            np.savetxt(f"./results/{training_name}/{seed}_{training_name}.txt", pred_ans)
            # np.savetxt("./results/y_15M_criteo.txt", y)
            print("")
            # print("test LogLoss", round(log_loss(y, pred_ans), 4))
            # print("test AUC", round(roc_auc_score(y, pred_ans), 4))
            print("test Calibration", np.sum(pred_ans) / np.sum(y))