"""
Prompt Loader Module
"""

import os
import yaml


class PromptLoader:
    """Prompt Loader Class"""

    def __init__(self, templates_dir: str):
        """Initialize prompt loader

        Args:
            templates_dir: Path to template files directory
        """
        self.templates_dir = templates_dir

    def load_prompt(self, prompt_key: str) -> str:
        """Load specified prompt template

        Args:
            prompt_key: Key name of the prompt template (filename without extension)

        Returns:
            Formatted prompt template string
        """
        template_path = os.path.join(self.templates_dir, f"{prompt_key}.yaml")

        try:
            with open(template_path, 'r', encoding='utf-8') as f:
                template = yaml.safe_load(f)
                return template['prompt']
        except Exception as e:
            raise Exception(f"Failed to load prompt template: {str(e)}")

    def format_prompt(self, template: str, polynomial: str) -> str:
        """Format prompt template

        Args:
            template: Prompt template string
            polynomial: Polynomial expression to insert

        Returns:
            Formatted prompt string
        """
        return template.replace("<INPUT>", polynomial)
