#!/bin/bash
# Set environment variables openai-key
export OPENAI_API_KEY=""
export GOOGLE_API_KEY=""
export CUDA_VISIBLE_DEVICES="0,1,2,3"
export WANDB_PROJECT="ExGRPO"

### Name of the backbone model ###
MODEL="gemma-7b-it"
# MODEL="qwen2.5-7b-instruct"

MODEL_NAME_OR_PATH="google/gemma-7b-it"
# MODEL_NAME_OR_PATH="Qwen/Qwen2.5-7B-Instruct"

###### CoT-Distill Model ######
### Single-turn CoT Distillation w/ or w/o Augmented Questions ###
# MODEL_NAME_OR_PATH="./exp/gemma-7b-it/arc_challenge/cot_distill/original"
# MODEL_NAME_OR_PATH="./exp/gemma-7b-it/arc_challenge/cot_distill/augment_with_gt_answer"
# MODEL_NAME_OR_PATH="./exp/gemma-7b-it/arc_challenge/cot_distill/augment_without_gt_answer"

### Multi-turn CoT Distillation ###
MODEL_NAME_OR_PATH="./exp/mistral-7b-instruct/arc_challenge/multiturn_cot_distill/random_4_augment_questions"

### Task Parameters ###
# TASK="anli"
TASK="arc_challenge"
# TASK="commonsense_qa"
# TASK="date"
# TASK="gsm8k"
# TASK="math"
# TASK="table_mwp"
# TASK="strategy_qa"

NUM_GPUS=$(echo $CUDA_VISIBLE_DEVICES | tr ',' '\n' | wc -l)

# port=$(shuf -i 6000-9000 -n 1)
# echo $port

# Set the logging level for the `accelerate` library to output informational messages.
ACCELERATE_LOG_LEVEL=info

# Change to the project root directory and set PYTHONPATH
SCRIPT_DIR="$(dirname "$0")"
cd "$SCRIPT_DIR"
export PYTHONPATH="$SCRIPT_DIR/src:$PYTHONPATH"

accelerate launch --config_file recipes/accelerate_configs/zero3.yaml --num_processes ${NUM_GPUS} \
  src/open_r1/multi_turn_grpo.py \
  --config recipes/${MODEL}/${TASK}/config_multiturn_grpo.yaml