import argparse

def get_parser():
  parser = argparse.ArgumentParser()
  # general settings
  parser.add_argument('--data-name', default='bench201_8', help='graph dataset name')
  parser.add_argument('--dataset', default='imagenet32', help='image dataset name')
  parser.add_argument('--save_dir', '--sa', default=None,
                      help='what to append to data-name as save-name for results')
  parser.add_argument('--save-interval', '--si', type=int, default=20, metavar='N',
                      help='how many epochs to wait each time to save model states')
  parser.add_argument('--gpu', '--g', type=str, default='0')
  parser.add_argument('--epochs', type=int, default=500, metavar='N',
                      help='number of epochs to train')
  parser.add_argument('--batch-size', type=int, default=32, metavar='N',
                      help='batch size during training')
  parser.add_argument('--seed', type=int, default=1, metavar='S',
                      help='random seed (default: 1)')
  parser.add_argument('--load_pretrain', action='store_true', default=False)
  parser.add_argument('--pretrain', '--p', action='store_true', default=False)
  parser.add_argument('--test', action='store_true', default=False)
  parser.add_argument('--rlv', action='store_true', default=False)
  parser.add_argument('--debug', '--d', action='store_true', default=False)

  # model
  parser.add_argument('--model', default='MetaD2A') 
  parser.add_argument('--d_enc_lr', type=float, default=1e-4, metavar='LR',
                      help='learning rate (default: 1e-4)')
  parser.add_argument('--g_enc_lr', type=float, default=1e-4, help='learning rate (default: 1e-4)')
  parser.add_argument('--pred_lr', type=float, default=1e-4, help='learning rate (default: 1e-4)')
  parser.add_argument('--input_type', '--it', type=str, default='DG')
  parser.add_argument('--acc_norm', '--a', action='store_true', default=True)
  # set encoder
  parser.add_argument('--max_img', type=int, default=20)
  parser.add_argument('--mode', type=str, default="sabPF")
  parser.add_argument('--setenc_type', '--st', type=int, default=1)
  # graph encoder
  parser.add_argument('--cn', action='store_true', default=True)
  parser.add_argument('--nvt', type=int, default=7, help='number of different node types, \
                      6 for final_structures6, 8 for asia_200k, 7 bench201_8-including in/out node')
  parser.add_argument('--hs', type=int, default=56, metavar='N',
                      help='hidden size of GRUs')
  parser.add_argument('--nz', type=int, default=56, metavar='N',
                      help='number of dimensions of latent vectors z')
  parser.add_argument('--bidirectional', '--bi', action='store_true', default=True,
                      help='whether to use bidirectional encoding')

  # test
  parser.add_argument('--dname', type=str, default=None)
  parser.add_argument('--rand_type', type=str, default='uniform') 
  args = parser.parse_args()
  
  return args
