import os

from utils.data_functions import load_data_from_file, write_data_to_file
from utils.helper_functions import get_repo_path

 # ------------------------------------ DIR ------------------------------------'
script_dir       = os.path.dirname(__file__)
print("script_dir: ", script_dir)

repo_path = get_repo_path(script_dir, 2)
print("repo_path: ", repo_path)

ground_truth_sequences = load_data_from_file(f'{repo_path}/data/noisy_dna/data/File1_ODNA.txt')
indices = []
for gt_seq in ground_truth_sequences:
    indices.append(gt_seq[42:54])

write_data_to_file(filepath='indices.txt', data=indices)
print('INDICES SAVED')