import Levenshtein


def hamming_distance(s1, s2):

    """
    Compute the Hamming distance between two strings. If the strings have different length we cut the longer string. 

    Args:
    s1 (str): The first string.
    s2 (str): The second string.

    Returns:
    int: The Levenshtein distance between the two strings.
    """
    
    min_length = min(len(s1), len(s2))

    distance = 0

    for i in range(min_length):
        if s1[i] != s2[i]:
            distance += 1

    return distance


def levenshtein_distance(s1, s2):

    """
    Compute the Levenshtein distance between two strings.

    Args:
    s1 (str): The first string.
    s2 (str): The second string.

    Returns:
    int: The Levenshtein distance between the two strings.
    """

    if len(s1) == 0:
        return len(s2)
    if len(s2) == 0:
        return len(s1)

    matrix = [[0] * (len(s2) + 1) for _ in range(len(s1) + 1)]

    for i in range(len(s1) + 1):
        matrix[i][0] = i
    for j in range(len(s2) + 1):
        matrix[0][j] = j

    for i in range(1, len(s1) + 1):
        for j in range(1, len(s2) + 1):
            if s1[i - 1] == s2[j - 1]:
                cost = 0
            else:
                cost = 1
            matrix[i][j] = min(matrix[i - 1][j] + 1, 
                               matrix[i][j - 1] + 1,  
                               matrix[i - 1][j - 1] + cost) 

    return matrix[-1][-1]

if __name__ == "__main__":
    print('Running distance_functions.py')

    s1 = 'ACAC'
    s2 = 'CAC'

    print('Hamming:', hamming_distance(s1, s2))
    print('Levenshtein:', levenshtein_distance(s1, s2))
    print('Levenshtein1:', Levenshtein.distance(s1,s2))
 