
from collections import Counter
from typing import List
import operator

def majority_merge(reads,weight = 0.4):
    # assume reads have the same lenght
    res = ""
    for i in range(len(reads[0])):
        counts = {'A':0,'C':0,'G':0,'T':0,'-':0,'N':0}
        for j in range(len(reads)):
            counts[reads[j][i]] +=1
        counts['-'] *= weight
        mv = max(counts.items(), key=operator.itemgetter(1))[0]
        if mv != '-':
            res += mv
    return res


def extended_majority_vote(list, length, check_length):
    """
    Computes a position-wise majority vote over a list of strings.

    Args:
    list (list): The list of strings, possibly of different lengths.
    length (int): The length of the result string.
    check_length (int): The intended length of the lists.

    Returns:
    string: The result string.
    """
    max_len = max([len(s) for s in list])

    print_flag = False

    # Pad shorter strings with a special character
    strs = [s.ljust(max_len, '#') for s in list]

    if print_flag:
        print('strs:', strs)

    transposed = zip(*strs)

    # Find the most common character at each position, handling ties between '#' and another character
    most_common_chars = []
    for chars in transposed:

        counter = Counter(chars)
        most_common = counter.most_common()
        
        if 'I' in chars:
            most_common_chars.append('-')
        elif 'D' in chars:
            for char, count in most_common:
                if char != 'D' and char != '-':
                    most_common_chars.append(char)
                    break
        else:
            most_common_chars.append(most_common[0][0])
    # Join these characters together to form the final string
    result = ''.join(most_common_chars)
    return result


if __name__ == '__main__':

    print("Running majority_vote.py")
    