#!/bin/bash
set -e  # Exit if any command fails
echo "Starting experiment runs..."

SEEDS=(29 42 48 72 95)
MAX_CONCURRENT_JOBS=8

# # Table 1 (Y-split and X-split. Refer to README!!)
# PROPERTIES=("bace" "esol" "freesolv" "lipo" "bace_x" "esol_x" "freesolv_x" "lipo_x")
# split_method=scaffold
# dataset=molnet
# task=regression

# # Table 2 (X-split)
# PROPERTIES=("bbbp_x" "clintox_x" "sider_x")
# split_method=scaffold
# dataset=molnet
# task=classification

# # Table 2 (X-split) DrugOOD_ori
# PROPERTIES=("core_ec50" "core_ic50")
# split_method=scaffold
# dataset=drugood_ori
# task=classification

# # Table 2 (X-split) DrugOOD_ours
# PROPERTIES=("core_ec50" "core_ic50")
# split_method=scaffold
# dataset=drugood_ours
# task=classification

# # Table 16 Hi split
# PROPERTIES=("bace" "esol" "freesolv" "lipo")
# split_method=hi
# dataset=molnet
# task=regression

# # Table 16 Lo split
# PROPERTIES=("bace" "esol" "freesolv" "lipo")
# split_method=lo
# dataset=molnet
# task=regression

# Table 15 Activity Cliffs (Split by definition)
PROPERTIES=('CHEMBL1862_Ki' 'CHEMBL1871_Ki' 'CHEMBL2034_Ki' 'CHEMBL2047_EC50' 'CHEMBL204_Ki' 'CHEMBL2147_Ki' 'CHEMBL214_Ki' 'CHEMBL218_EC50' 'CHEMBL219_Ki' 'CHEMBL228_Ki' 'CHEMBL231_Ki' 'CHEMBL233_Ki' 'CHEMBL234_Ki' 'CHEMBL235_EC50' 'CHEMBL236_Ki' 'CHEMBL237_EC50' 'CHEMBL237_Ki' 'CHEMBL238_Ki' 'CHEMBL239_EC50' 'CHEMBL244_Ki' 'CHEMBL262_Ki' 'CHEMBL264_Ki' 'CHEMBL2835_Ki' 'CHEMBL287_Ki' 'CHEMBL2971_Ki' 'CHEMBL3979_EC50' 'CHEMBL4005_Ki' 'CHEMBL4203_Ki' 'CHEMBL4616_EC50' 'CHEMBL4792_Ki')
split_method=ac
dataset=ac
task=regression

echo "========================================"

for property in "${PROPERTIES[@]}"; do
    echo "Processing property: ${property}"
    for seed in "${SEEDS[@]}"; do
        # Check for concurrency limit
        while [ $(jobs -p | wc -l) -ge ${MAX_CONCURRENT_JOBS} ]; do
            wait -n
        done
        echo "Launching:"
        echo "  property: ${property}"
        echo "  Seed: ${seed}"
        python main.py -dn "${dataset}" --prop_type "${property}" -ds "${split_method}" -s "${seed}" -t "${task}" &
    done
done

wait

echo "All experiments finished!"

