#!/bin/bash

PROPERTIES=("bace" "esol" "freesolv" "lipo")

echo "Starting Lo-Hi split generation for all specified datasets in parallel..."
echo ""

for property in "${PROPERTIES[@]}"; do
    (
        echo "------------------------------------------------------"
        echo ">>> Launching processing for dataset: ${property}"
        echo "------------------------------------------------------"
        
        python process_lohi.py --property="${property}"
        
        if [ $? -eq 0 ]; then
            echo ">>> Successfully finished processing: ${property}"
        else
            echo ">>> An error occurred while processing: ${property}"
        fi
        echo ""
    ) & 
done

echo ">>> All processing jobs launched. Waiting for them to complete..."
wait

echo "======================================================"
echo "All datasets have been processed."
echo "======================================================"