## CARD: Certifiably Robust Machine Learning Pipeline via  Domain Knowledge Integration

+ code/ contains the source code for our experiments
+ data/ is for the download of dataset.

For our pipeline, you should first train the main sensor through 

`python code/train_main.py --dataset AWA --arch resnet50 --outdir code/main_models/ --epochs 30 --batch 256 --lr 0.001 --lr_step_size 20 --gpu 0,1`

Then train the corresponding knowledge predictors, i.e., the attribute predictor and the hierarchy predictor.

 `python code/train_attribute.py --dataset AWA --arch resnet50 --outdir code/attribubte_models/ --epochs 30 --batch 256 --lr 0.001 --lr_step_size 20 --weight 2 --gpu 0,1`

 `python code/train_hierarchy.py --dataset AWA --arch resnet50 --outdir code/hierarchy_models/ --epochs 30 --batch 256 --lr 0.001 --lr_step_size 20 --weight 2 --gpu 0,1`

Next, we would train the importance score in the reasoning model with the simulated data, through

`python code/train_reasoning.py --dataset AWA --outdir reasoning_model/cohen_main+attrNP+hierNP --train 10000 --test 1000 --epochs 10`

The output of the main predictors and the knowledge predictors would be concatenated to a single vector in the `code/core.py`.

For the prediction, the program `code/predict.py` makes predictions using *g* on a bunch of inputs.

`python code/predict.py AWA --base_classifier/main_model_sd025/checkpoint.pth.tar --sigma 0.25 --outdir prediction_results/AWA/noise_0.25 --alpha 0.001 --N 100 --skip 100 --card`

For the certification, the program `code/certify.py` certifies the robustness of g on bunch of inputs.

`python code/certify.py AWA --base_classifier/main_model_sd025/checkpoint.pth.tar --sigma 0.25 --outdir prediction_results/AWA/noise_0.25 --alpha 0.001 --N0 100 --N 10000 --card`

The implementation of the simulated training starts from the line 340 of `code/datasets.py` and the implementation of the reasoning model starts from the line 94 of `code/architectures.py`

