# Fine-Grained Few-Shot Recognition by Deep Object Parsing -- ICLR 2023 submission


## Abstract
We propose a new method for fine-grained few-shot recognition via deep object parsing.
In our framework, an object is made up of K distinct parts and for each part, we learn a dictionary of templates, which is shared across all instances and categories. An object is parsed by estimating the locations of these $K$ parts and a set of active templates that can reconstruct the part features. 
We recognize test instances by comparing its active templates and the relative geometry of its part locations against those of the presented few-shot instances. Our method is end-to-end trainable to learn part templates on-top of a convolutional backbone. To combat visual distortions such as orientation, pose and size, we learn templates at multiple scales, and at test-time parse and match instances across these scales. We show that our method is competitive with the state-of-the-art, and by virtue of parsing enjoys interpretability as well.

## Dependencies

You can follow steps in ```install.md``` to install required dependencies in a conda environment.


## Usage
### Datasets

#### CUB
- Download the dataset from [here](http://www.vision.caltech.edu/visipedia/CUB-200-2011.html).
#### Stanford Dogs
- Download the dataset from [here](http://vision.stanford.edu/aditya86/ImageNetDogs/).
#### Stanford Cars
- Download the dataset from [here](http://ai.stanford.edu/~jkrause/cars/car_dataset.html).
#### Aircraft
- Download the dataset from [here](http://www.robots.ox.ac.uk/~vgg/data/fgvc-aircraft/).

The split follows standard fine-grained few shot learning. This can be found in ```datasets```. You can download data to your specified directory a and extract in the folder. For example, for Stanford Car dataset it can be extracted at ```/Path/to/car/```. The path of the folder is used in later as the argument ```--data_dir``` .

### Train
We provide training script for CAR dataset on ResNet18 as an example. ```--default_root_dir``` is the path for saving tensorboard logs. ```--data_dir``` is directory of data. The default hypterparameter setting can replicate the results reported in the data.

```
python fsl_train.py --default_root_dir /Path/to/car/save_dir --data_dir /Path/to/car/ --split_dir datasets/StanfordCars_split --data_name CAR  --attn_conv_size 1 --attn_conv_size1 3 --attn_conv_size1 5  --check_val_every_n_epoch 5 --input_size 84 --iterations_val 200 --loss_weights 50 1. --lr 1e-3 --max_epochs 300 --mu_conv_size 5 --mu_softmax_temp 0.1 --num_attn 3 --scheduler_gamma 0.1 --scheduler_step_size 90 --sigma 0.5 --temp_proto 0.01 --train_mode episode --classes_per_it_tr 10 --num_query_tr 10 --iterations_tr 100 --shrinkage_mrg 0.1 --alpha=0.0001 --backbone_model resnet18  
```
### Test

Run ```fsl_train.py``` with same arguments as above and additionally specify ```--test_ckpt /Path/to/car/save_dir/last.ckpt``` (which is the location where the checkpoint is saved).
