import json
from tqdm import tqdm

def load_json(file_path):
    # load the json file
    with open(file_path, 'r') as file:
        data = json.load(file)
    
    print(data)
    # map keys "A" -> "sentence1" and "B" -> "sentence2"
    for i in range(len(data)):
        d = data[i]
        d["sentence1"] = d["A"]
        d["sentence2"] = d["B"]
        del d["A"]
        del d["B"]
        d["gold_label"] = "entailment"
    return data

def load_jsonl(file_path_list):
    data = []
    for file_path in file_path_list:
        with open(file_path, 'r') as file:
            for line in file:
                data.append(json.loads(line))
    
        print(f"Loaded {len(data)} examples from {file_path}")
    return data

def load_tsv(file_path_list):
    data = []
    header = None
    for file_path in file_path_list:
        with open(file_path, 'r') as file:
            # Read the header if it's the first file
            if header is None:
                header = file.readline().strip().split('\t')
            else:
                # Skip the header for subsequent files
                next(file)
            
            # Read the rest of the lines
            for line in file:
                values = line.strip().split('\t')
                example = {header[i]: values[i] for i in range(len(header))}
                data.append(example)
        
        print(f"Loaded {len(data)} examples from {file_path}")
    return data

def make_chat_call(client, model, message, max_tokens):

    if "gpt" in model:
        full_prompt = [{'role': 'user', 'content': message}]
    elif "claude" in model:
        full_prompt = [{'role': 'user', 'content': [{"type": "text", "text": message}]}]

    response = None
    wait_time = 5
    while response is None:
        try:
            if "gpt" in model:
                response = client.chat.completions.create(
                    model=model,
                    messages=full_prompt,
                    max_tokens=max_tokens,
                    n=1
                )
                for r in response.choices:
                    if r.finish_reason == "content_filter":
                        print("Content filter triggered, trying again")
                        response = None
            
            elif "claude" in model:
                response = client.messages.create(
                    model=model,
                    messages=full_prompt,
                    max_tokens=max_tokens,
                    temperature=1
                )
                if response.stop_reason != "end_turn":
                    print("End turn not triggered, trying again")
                    response = None
                
                # print(response.content)
            
        except Exception as e:
            print(f'Caught exception {e}.')
            # print(f'Waiting {wait_time} seconds.')
            time.sleep(wait_time)

    return response