import os
import sys
import ast
import json 
import yaml
import argparse
from tqdm import tqdm
from pathlib import Path
from random import random
from dataclasses import dataclass
from typing import Literal, Optional, Union, Tuple
import random
from rich import print
import time
from src.openai_utils import OpenAI
# from utils import make_chat_call

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model_name", type=str, default="redacted")
    parser.add_argument("--output_dir", type=str, default="redacted")
    parser.add_argument("--task_name", type=str, default="glue_rte")
    parser.add_argument("--base_model_name", type=str, default="gpt4o")
    args = parser.parse_args()
        
    if args.task_name == "glue_rte":
        with open('redacted/glue_rte/datasets_920.json') as f:
            dataset = json.load(f)
    elif args.task_name == "glue_mnli":
        with open('redacted/glue_mnli/datasets_6704.json') as f:
            dataset = json.load(f)
    elif args.task_name == "snli":
        with open('redacted/snli/datasets_6690.json') as f:
            dataset = json.load(f)
    elif args.task_name == "gpt_generated":
        with open('redacted/gpt_generated/datasets_100_gpt_generated_none_7.json') as f:
            dataset = json.load(f)
    
    else:
        raise ValueError(f"Task name {args.task_name} not recognized.")
    print(f"len(dataset): {len(dataset)}")
    
    if len(dataset) > 1000:
        dataset = dataset[:1000]
    output_dir = Path(args.output_dir, f"{args.task_name}_{args.base_model_name}")
    output_dir.mkdir(parents=True, exist_ok=True)
    output_file = output_dir / "outputs.jsonl"
    with open(output_file, "w") as f: 
        for datapoint in tqdm(dataset, total=len(dataset)):
            agent = OpenAI()
            completions = dict()
            for prompt_name, prompt in datapoint.items():
                response = agent.complete([prompt])
                print(f"response: {response}")
                completions[prompt_name] = response
            
            output = dict(
                datapoint=datapoint,
                completions=completions
            )
            f.write(json.dumps(completions) + "\n")
        
                
            