import os
import sys
import ast
import json 
import yaml
import argparse
from tqdm import tqdm
import torch
from pathlib import Path
from random import random
from dataclasses import dataclass
from typing import Literal, Optional, Union, Tuple
import random
from rich import print
import time
from vllm import LLM, SamplingParams

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model_name", type=str, default="redacted")
    parser.add_argument("--output_dir", type=str, default="redacted")
    parser.add_argument("--prompt_name", type=str, default="new_agl")
    parser.add_argument("--base_model_name", type=str, default="gpt2")
    args = parser.parse_args()
        
    with open('redacted') as f:
        dataset = json.load(f)
    
    with open("redacted", "r") as file:
        template = yaml.safe_load(file)
    
    model_name = args.model_name    
    llm = LLM(model=model_name, 
              trust_remote_code=True,
              tensor_parallel_size=4)
    print(f"llm: {llm}")
    tokenizer = llm.get_tokenizer()
    sampleparams= SamplingParams(
                    temperature=0.0,
                    max_tokens=1024,
                    stop_token_ids=[tokenizer.eos_token_id, tokenizer.convert_tokens_to_ids("<|eot_id|>")],  # KEYPOINT HERE
                )

    prompt_template = template[args.prompt_name]
    print(f"prompt_template: {prompt_template}")
    
    output_dir = Path(args.output_dir, f"{args.prompt_name}_{args.base_model_name}")
    output_dir.mkdir(parents=True, exist_ok=True)
    output_file = output_dir / "outputs.jsonl"
    eval_file = output_dir / "eval.jsonl"
    # if os.path.exists(output_file):
    #     check = input(f"File {output_file} already exists. Overwrite? (y/n): ")
    #     if check.lower() != "y":
    #         sys.exit()
    accuracy = 0
    with open(output_file, "w") as f: 
        for datapoint in tqdm(dataset, total=len(dataset)):
            test = datapoint['test']
            fake = datapoint['fakes']
            test_examples = test + fake
            random.shuffle(test_examples)
            train_examples = '\n'.join(datapoint['train'])
            prompts = [prompt_template.format(train_examples=train_examples, test_example=test_example) for test_example in test_examples]
            conversations = []
            for prompt in prompts:
                conversations.append(tokenizer.apply_chat_template(
                    [{'role': 'user', 'content': prompt}],
                    tokenize=False,
                ))
            outputs = llm.generate(
                conversations,
                sampleparams
            )
            completions = []
            for out in outputs:
                generated_text = out.outputs[0].text
                completions.append(generated_text)
            output = dict(
                test_examples=test_examples,
                train_examples=train_examples,
                completions=completions
            )
            # print(f"output: {output}")
            f.write(json.dumps(output) + "\n")