import os
import sys
import ast
import json 
import yaml
import argparse
from tqdm import tqdm
from pathlib import Path
from random import random
from dataclasses import dataclass
from typing import Literal, Optional, Union, Tuple
import random
from rich import print
import time
from src.openai_utils import OpenAI
import jsonlines


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model_name", type=str, default="redacted")
    parser.add_argument("--output_dir", type=str, default="redacted")
    parser.add_argument("--prompt_name", type=str, default="Zeroshot_Prompt_Memorize")
    parser.add_argument("--base_model_name", type=str, default="gpt4o")
    args = parser.parse_args()
    
    output_dir = f"redacted/CoT_Prompt_Memorize_gpt4o"
    output_file = f"{output_dir}/outputs.jsonl"
    
    print(f"output_file: {output_file}")
    with jsonlines.open(output_file) as reader:
        dataset = [obj for obj in reader]
        
    with open('redacted') as f:
        ori_dataset = json.load(f)
        
    with open(output_dir + "/example_eval.jsonl", "w") as f:
        sample_id = 0
        accuracy = []
        for datapoint, ori_datapoint in tqdm(zip(dataset, ori_dataset), total=len(dataset)):
            test = ori_datapoint['test']
            fake = ori_datapoint['fakes']
            ground_truth = []
            agent = OpenAI()
            for test_example in datapoint['test_examples']:
                if test_example in test:
                    ground_truth.append("yes")
                elif test_example in fake:
                    ground_truth.append("no")
                else:
                    raise ValueError(f"test_example {test_example} not found in test or fake")
            completions = datapoint['completions']
            datapoint_correct = []
            for answer,ground_tru in zip(completions, ground_truth):
                prompt = f"Extract the final answer in the following explanation? Only extract the answer 'yes' or 'no'. \n\n{answer}"
                response = agent.complete([prompt])
                print(f"answer: {answer}")
                print(f"response: {response}")

                if "yes" in response.lower() and ground_tru == "yes":
                    datapoint_correct.append(1)
                elif "no" in response.lower() and ground_tru == "no":
                    datapoint_correct.append(1)
                else:
                    datapoint_correct.append(0)
            # print(f"datapoint_correct: {datapoint_correct}")
            # input()
            datapoint_acc = sum(datapoint_correct) / len(datapoint_correct)
            accuracy.append(datapoint_acc)
            output= dict(
                sample_id = sample_id,
                datapoint_results = datapoint_correct,
                datapoint_accuracy = datapoint_acc
            )
            f.write(json.dumps(output) + "\n")
            sample_id += 1
        
        acc = sum(accuracy) / len(accuracy)
        metrics = dict(
            accuracy = acc
        )
        with open(output_dir + "eval.json", "w") as f:
            f.write(json.dumps(metrics))
    print(f"accuracy: {acc}")
        
        
            
       