import os
import sys
import ast
import json 
import yaml
import argparse
from tqdm import tqdm
import torch
from pathlib import Path
from random import random
from dataclasses import dataclass
from typing import Literal, Optional, Union, Tuple
import random
from rich import print
import time
from vllm import LLM, SamplingParams
from src.utils import print_gpu_usage


def inference(args, template=None, queries=None, groupa1=None, groupa2=None):
    model_name = args.model_name    
    llm = LLM(model=model_name, 
              trust_remote_code=True,
              tensor_parallel_size=4)
    print(f"llm: {llm}")
    
    tokenizer = llm.get_tokenizer()
    output_dir = Path(args.output_dir)
    output_dir.mkdir(parents=True, exist_ok=True)
    output_file = output_dir / "output.jsonl"
    if os.path.exists(output_file):
        check = input(f"File {output_file} already exists. Overwrite? (y/n): ")
        if check.lower() != "y":
            sys.exit()
    
    with open(output_file, "w") as f:
        for query in tqdm(queries, total=len(queries)):
            prompt = template.format(query=query)
            conversations = tokenizer.apply_chat_template(
                [{'role': 'user', 'content': prompt}],
                tokenize=False,
            )
            if query in groupa1:
                groudtruth = "A1"
            else:
                groudtruth = "A2"
            outputs = llm.generate(
                [conversations],
                SamplingParams(
                    temperature=0.7,
                    top_p=0.9,
                    max_tokens=1024,
                    stop_token_ids=[tokenizer.eos_token_id, tokenizer.convert_tokens_to_ids("<|eot_id|>")],  # KEYPOINT HERE
                )
            )
            for out in outputs:
                generated_text = out.outputs[0].text
                print(f"generated_text: {generated_text}")
                # print(f"output: {out}")
                # input()
            output = dict(
                query=query,
                prompt=prompt,
                generated_text=generated_text,
                groudtruth=groudtruth
            )
            f.write(json.dumps(output) + "\n")
    
    
if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model_name", type=str, default="redacted")
    parser.add_argument("--output_dir", type=str, default="redacted")
    parser.add_argument("--task", type=str, default="agl")
    args = parser.parse_args()
    
    print(f"[bold green]Inference completed![/bold green]")
    
    if args.task == "agl":
        with open("redacted/configs/prompts.yaml", "r") as file:
            template = yaml.safe_load(file)
        
        query = "RMDLALDG"
        prompts_templates = "## Instruction: " + template["instruction"] + "\n\n" + template["study_stimuli"] + "\n\n" + template["question"]
        # prompts_templates= prompts_templates.format(query=query)
    
        with open("redacted/configs/agl.yaml", "r") as file:
            test = yaml.safe_load(file)
        
        group_a1 = test['queries']['A1']
        group_a2 = test['queries']['A2']
        queries = group_a1 + group_a2
        # random shuffle the queries 
        random.shuffle(queries)

        inference(args, prompts_templates, queries, group_a1, group_a2)
        
        print_gpu_usage()
   
    
    
    
    

