# OCL

This repo contains the implementation of our proposed OCRN (`./network/OCRN.py`), which is implemented with Python 3.8 + PyTorch 1.8.1. With the provided data subset (30 images for training and 30 for testing, features are given), you can train an OCRN by first extract ResNet feature:

    python extract_feature.py --cfg config/Faster50Feature.yaml


then running:

    CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 run_ocl.py --cfg config/OCRN_stage1.yaml;
    CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 run_ocl.py --cfg config/OCRN_stage2.yaml --trained_weight logs/OCRN_stage1/checkpoint_ep470.pt --weight_type pretrain;
    

... and evaluate by:

    CUDA_VISIBLE_DEVICES=0,1,2,3 python test_tde.py --cfg config/OCRN_stage2.yaml --trained_weight logs/OCRN_stage2/checkpoint_ep20.pt --weight_type pretrain;

The results of the best OCRN model can be found in `./report/


Note that: the category affordance/attribute matrix will be opened in the later versions and we use random matrices as placeholders in this code (`models/OCRN_base_model.py`, line 35-40).