from symbols.symbols.distribution_symbol import DistributionSymbol

import numpy as np



class UniqueSymbolList:


    def __init__(self):
        self._list = list()

    def add(self, symbol: DistributionSymbol):
        """
        Add a symbol to the list, checking for duplicates before inserting
        :param symbol: the symbol to insert
        :return: the index of the symbol in the list, and whether the symbol was actually inserted
        """
        # TODO Change
        for i, x in enumerate(self._list):
            if set(symbol.mask) == set(x.mask) and x.is_similar(symbol, threshold=150):
                print("Found dup: {} - {} ".format('symbol_' + str(len(self._list) + 1), x.name))
                return i, False

        symbol.name = 'symbol_' + str(len(self._list) + 1)
        self._list.append(symbol)
        return len(self._list) - 1, True

    def __getitem__(self, index):
        if index >= len(self):
            raise IndexError("UniqueSymbolsList index out of range")
        return self._list[index]

    def __len__(self):
        return len(self._list)

