


class Option:
    """
    A simple class that keeps track of when an option has finished executing
    """
    def __init__(self):
        self.done = False
        self.name = self.__class__.__name__

    def step(self, state):

        if self.done or self.is_terminated(state):
            self.done = True
            return None

        return self.policy_step(state)

    def initialise(self):
        self.done = False

    def policy_step(self, state): raise NotImplemented

    def is_terminated(self, state): raise NotImplemented

    def __str__(self):
        return self.name
