

class ConditionalSymbol:
    """
    Abstract base class for a conditional symbol (a probabilistic classifier) which determines whether a given
    state is in the precondition of an option
    """

    @property
    def mask(self):
        """
        Get the state variables over which this classifier applies
        :return: the list of state variable over which we perform classification
        """
        raise NotImplementedError("Called abstract base class method ConditionalSymbol::mask.")

    def probability(self,
                    state):
        """
        Determine the probability of a state being in the precondition
        :param state: the state
        :return: the probability that the state belongs to the option's precondition
        """
        raise NotImplementedError("Called abstract base class method ConditionalSymbol::probability.")

    def sample_error(self,
                     states,
                     labels):
        """
        Determine the sample error of the classifier
        :param states: the states over which to test
        :param labels: the labels of the states
        :return: the sample error of the predictions
        """
        raise NotImplementedError("Called abstract base class method ConditionalSymbol::sample_error.")