


class RewardSymbol:
    """
    Abstract base class for a reward symbol (a regressor).
    """
 
    def predict_reward(self,
                       state):
        """
        Predict the reward obtained for being in the current state and executing the current option. There should be
        reward symbols associated with each option, and so the option is implicit here.
        :param state: the current state
        :return: the estimated reward for executing a given option
        """
        raise NotImplementedError("Called abstract base class method RewardSymbol::predict_reward.")
    
    def expected_reward(self,
                        distribution_symbol):
        """
        Predicts the expected reward for being in a current distribution over states and executing an option. There
        should be reward symbols associated with each option, and so the option is implicit here.
        :param distribution_symbol: the current distribution over states
        :return: the estimated reward for executing a given option
        """
        raise NotImplementedError("Called abstract base class method RewardSymbol::expected_reward.")