import numpy as np



class PreconditionSample:
    """
    A class holding a sample of a precondition, which is simply a (state, option, bool) tuple specifying whether the
    option could be executed in the given state.
    """

    def __init__(self,
                 state: np.ndarray,
                 observation: np.ndarray,
                 option: int,
                 object_id: int,
                 can_execute: bool,
                 view='problem'):

        self._option = option
        self._can_execute = can_execute
        self._object_id = object_id
        self.episode = None

        if view == 'problem':
            self._state = state
            self._observation = observation
        elif view == 'agent':
            self._state = observation
            self._observation = state

    @property
    def object_id(self):
        return self._object_id

    @property
    def state(self):
        return self._state

    @property
    def observation(self):
        return self._observation


    @property
    def flat_state(self):
        return np.concatenate(self.state).ravel()

    @property
    def flat_observation(self):
        return np.concatenate(self.observation).ravel()

    @property
    def option(self):
        return self._option

    @property
    def can_execute(self):
        return self._can_execute

