from symbols.pddl.schema import Schema




class Conjunction:

    def __init__(self, symbols, reward, probability=1, display_only=False):
        """
        Create a new conjunction of symbols
        :param symbols: the symbols being set/unset
        :param reward: the reward
        :param probability: the probability of the conjunction executing
        :param display_only: whether this is for display purposes only. If true, we do not compute the symbols'
        conjunction
        """
        self._symbols = symbols
        self._reward = reward
        self._probability = probability

        # calculate the conjunction for later
        # todo what to do about negations (pos - neg)?
        # symbols = [symbol.symbol for symbol in self._symbols if symbol.sign > 0]
        #
        # if len(symbols) > 0 and not display_only:
        #     self._conjunction = DistributionSymbol.conjoin(symbols)
        # else:
        #     self._conjunction = None

        # if len(symbols) == 0:
        #     raise RuntimeError
        #
        # if not display_only:
        #     self._conjunction = DistributionSymbol.conjoin(symbols)
            # self._conjunction = symbols[0]
            # name = symbols[0].id
            # for i in range(1, len(symbols)):
            #     self._conjunction = self._conjunction.distribution_and(symbols[i])
            #     name += "AND" + symbols[i].id

    @property
    def reward(self):
        return self._reward

    @property
    def symbols(self):
        return self._symbols

    @property
    def probability(self):
        return self._probability

    # def score_samples(self, states):
    #     if self._conjunction is None:
    #         return 0
    #     return self._conjunction.score_samples(states)
    #
    # def log_likelihood(self, state):
    #     if self._conjunction is None:
    #         return 0
    #     return self._conjunction.score(state)

    def __str__(self):
        prob = ''

        #TODO: hack - fix this - just checking PDDL validity

        if self.probability < 1: # and False:
            prob = str(self.probability) + '\t'

        # temp = 'increase'
        # r = self.reward
        # if r < 0:
        #     temp = 'decrease'
        #     r = -r
        # reward_str = temp + ' (reward) ' + '{0:.2f}'.format(r)
        reward_str = 'decrease (reward) 1.00'
        # return prob + Schema.conjunction_to_str(self._symbols + [reward_str])
        return prob + Schema.conjunction_to_str(self._symbols)
