from symbols.pddl.schema import Schema


class Description:

    def __init__(self, domain_name, symbols, action_descriptor):
        self._domain_name = domain_name
        self._symbols = symbols
        self._schemata = list()
        self._action_descriptor = action_descriptor

    def get_symbols(self):
        return self._symbols

    def add_schema(self, schema: Schema):
        schema.set_id(len(self._schemata))
        schema.action_descriptor = self._action_descriptor
        self._schemata.append(schema)

    def __str__(self):
        description = "; Automatically generated " + self._domain_name + " domain PPDDL file.\n"
        description += "(define (domain " + self._domain_name + ")\n"
        description += "\t(:requirements :strips :probabilistic-effects :rewards)\n"
        description += "\t(:predicates\n"
        description += "   \t\t(notfailed)\n"
        for i in range(len(self._symbols)):
            description += ("\t\t(" + str(self._symbols[i]) + ")\n")
        description += "\t)\n\n"
        # description += "\t(:functions (partition))\n\n"
        description += '\n\n'.join([str(s) for s in self._schemata])

        return description + '\n)'

    def __len__(self):
        return len(self._schemata)

    def __iter__(self):
        for schema in self._schemata:
            yield schema