clear all
close all
clc


%randn('state',2012)
%rand('state',2015)
x = [1;0] ;
sample_size=5;
A = randn(2,2,sample_size) ;

randn('state',508);


y=zeros(sample_size,1);
for i=1:sample_size
    y(i) = trace(A(:,:,i)*x*x');
end

az = -24 ;
el =  60 ;

%az = -22 ;
%el =  44 ;

%lambda = 5/(4-24/sample_size) ;

%[xx,yy]=meshgrid(-1.25:0.05:1.25,-1.2:0.05:1.2) ;

xvals = -1.2:0.05:1.2 ;
yvals = -1.3:0.05:1.3 ;
[x1,y1] = meshgrid(xvals,yvals) ;

fval=zeros(length(xvals),length(yvals));
for i=1:length(xvals)
    for j=1:length(yvals)
        for k=1:sample_size
           z=[xvals(i); yvals(j)];
           fval(i,j)=fval(i,j)+(1/sample_size)*trace(A(:,:,k)*(x*x'-z*z'))^2;
        end
    end
end    



%Calculate trajectory
iters=300;
u=zeros(2,iters);
%u(:,1)=0.01*randn(2,1);
u(1,1)=0.01;
u(2,1)=-0.05;
%grad=zeros(2,3721);
for k=1:iters-1
    %Calculate gradient
    grad=zeros(2,1);
    for i=1:sample_size
        grad=grad-A(:,:,i)*u(:,k)*trace(A(:,:,i)*(x*x'-u(:,k)*u(:,k)'));
    end
    %Update 
    u(:,k+1)=u(:,k)-(0.05/sample_size)*grad;
end

%Compute z-coordinates for trajectory
fval_z=0.05*ones(iters,1);
for i=1:iters
    z=[u(1,i); u(2,i)];
    for k=1:sample_size
           fval_z(i)=fval_z(i)+(1/sample_size)*trace(A(:,:,k)*(x*x'-z*z'))^2;
    end
end    


%Trajectory for power method
u_power=zeros(2,iters);
%u(:,1)=0.01*randn(2,1);
u_power(1,1)=u(1,1);
u_power(2,1)=u(2,1);
%grad=zeros(2,3721);
for k=1:iters-1
    %Calculate gradient
    grad=zeros(2,1);
    for i=1:sample_size
        grad=grad-A(:,:,i)*u_power(:,k)*trace(A(:,:,i)*(x*x'));
    end
    %Update 
    u_power(:,k+1)=u_power(:,k)-(0.05/sample_size)*grad;
end


%Compute z-coordinates for power method trajectory
fval_zpower=0.15*ones(iters,1);
for i=1:iters
    z=[u_power(1,i); u_power(2,i)];
    for k=1:sample_size
           fval_zpower(i)=fval_zpower(i)+(1/sample_size)*trace(A(:,:,k)*(x*x'-z*z'))^2;
    end
end    


%Calculate f at zero
fzero=0;
for k=1:sample_size
    fzero=fzero+(1/sample_size)*trace(A(:,:,k)*(x*x'))^2;
end


 
figure
h3Surf = surf(x1,y1,fval','FaceAlpha',0.5);
view(az,el) ;
hold on ;


stop_1=50;
stop_2=80;
%p1=plot3(u(1,1:stop_1+1),u(2,1:stop_1+1),fval_z(1:stop_1+1),'Color','red','MarkerSize',50,'MarkerFaceColor','#D9FFFF');
%p1.LineWidth = 5;
%p2=plot3(u(1,stop_1+1:stop_2+1),u(2,stop_1+1:stop_2+1),fval_z(stop_1+1:stop_2+1),'Color','green','MarkerSize',50,'MarkerFaceColor','#D9FFFF');
%p2.LineWidth = 5;
%p3=plot3(u(1,stop_2+1:iters),u(2,stop_2+1:iters),fval_z(stop_2+1:iters),'Color','black','MarkerSize',50,'MarkerFaceColor','#D9FFFF');
%p3.LineWidth = 5;
p4=plot3(u(1,1:iters),u(2,1:iters),fval_z(1:iters),'Color','magenta','MarkerSize',50,'MarkerFaceColor','#D9FFFF');
p4.LineWidth = 7;
p5=plot3(u_power(1,1:iters),u_power(2,1:iters),fval_zpower(1:iters),'Color','cyan','MarkerSize',5,'MarkerFaceColor','#D9FFFF');
p5.LineWidth = 7;
plot3(1,0,0.15,'bo','MarkerSize',22,'MarkerFaceColor','green');
plot3(-1,0,0.15,'bo','MarkerSize',22,'MarkerFaceColor','green');
plot3(0,0,fzero+0.1,'bo','MarkerSize',22,'MarkerFaceColor','white');
%drawPoint3d([1,0,0],'MarkerSize',20,'marker','.','color','g') ;
%scatter3(-1,0,0.1,'MarkerEdgeColor','k','MarkerFaceColor',[0 .75 .75],'Size',50);
axis([-1.2 1.2 -1.3 1.3 -0.1 4])
%axis off ;

%figure
%h2Surf = surf(x1,y1,z');
%view(az,el) ;
%hold on ;
%drawPoint3d([0,0,2],'MarkerSize',20,'marker','.','color','y') ;
%drawPoint3d([1,0,0],'MarkerSize',20,'marker','.','color','g') ;
%drawPoint3d([-1,0,0],'MarkerSize',20,'marker','.','color','g') ;
%drawPoint3d([0,sqrt(5/6),8/9],'MarkerSize',20,'marker','.','color','r') ;
%drawPoint3d([0,-sqrt(5/6),8/9],'MarkerSize',20,'marker','.','color','r') ;
%axis([-2 2 -2 2 -0.2 10])
%axis off ;

%figure
%h3Surf = surf(x1,y1,z'-fval');
%axis([-2 2 -2 2 -0.2 10])

%axis off