clear all;
close all;
clc      ;

%syms x y

n = 100 ;
iters = 100;

%[xx,yy]=meshgrid(-1.5:0.05:1.5,-1.5:0.05:1.5) ;

%theta     = [ xx(:).' ; yy(:).' ] ;
thetastar = [1;0] ;
%A=randn(n,2);
sample_size=10;
A = randn(2,2,sample_size) ;

x=zeros(2,iters);
x(:,1)=1.5*randn(2,1);
%grad=zeros(2,3721);
for k=1:iters-1
    %Calculate gradient
    grad=zeros(2,1);
    for i=1:sample_size
        grad=grad-A(:,:,i)*x(:,k)*trace(A(:,:,i)*(thetastar*thetastar'-x(:,k)*x(:,k)'));
    end
    %Update x
    x(:,k+1)=x(:,k)-(0.25/sample_size)*grad;
end


%u = reshape(grad(1,:),size(xx));
%v = reshape(grad(2,:),size(xx));
%XY = streamline(xx,yy,u,v) ;

%h= streamslice(xx,yy,-u,-v)
%set(h,'Linewidth',2);

%hold on
%plot(0,2/pi,'bo','MarkerSize',20,'MarkerFaceColor','red')
%plot(0,-2/pi,'bo','MarkerSize',20,'MarkerFaceColor','red')

%plot(0,0,'bo','MarkerSize',20,'MarkerFaceColor','yellow')

%plot(1,0,'bo','MarkerSize',20,'MarkerFaceColor','green')
%plot(-1,0,'bo','MarkerSize',20,'MarkerFaceColor','green')

%set(gca,'Fontsize',20)
%load wind
%zmax = max(z(:)); zmin = min(z(:));
%streamslice(x,y,z,u,v,w,[],[],(zmax-zmin)/2)
dlmwrite('trajectory_x4.csv',x', ' ')
