clear all;
close all;
clc      ;

d = 200      ;
rstar = 5      ;
r=70;
X = zeros(d) ;
U = orth(randn(d,rstar)) ;
X = U*U' ; 

m = 10*d*rstar ;

A = randn(m,d^2) ;


y = A*X(:) ;

nu = 1/(10*d^2);
%nu=2;
Ut = nu*randn(d,r);
Xt = Ut*Ut' ;

mu = 1/(4*m) ;

iters = 100 ;


M=(1/m)*reshape(A'*(A*X(:)),[d,d]);
M=1/2*(M+transpose(M));
[V_M,Sigma_M,W_M] = svd(M);

VMperp=transpose(V_M(:,(rstar+1):d));
angle=zeros(iters,1);
angle_tilde=zeros(iters,1);
sigma_min=zeros(iters,1);
loss=zeros(iters,1);
Uttilde=Ut;
loss_zero=norm(X*X','fro')^2;
for t = 1 : iters
 
    %Ut = Ut-mu*reshape(A'*(A*Xt(:)-y),[d,d])*Ut ;
    Zt=reshape(A'*(A*Xt(:)-y),[d,d]);
    Xt = Ut*Ut' ;
    Zt=1/2*(transpose(Zt)+Zt);
    Ut = Ut-mu*Zt*Ut ;
    [V_Ut,Sigma_Ut,W_Ut] = svd(Ut);
    V_Utperp=transpose(V_Ut(:,(rstar+1):d));
    angle(t)=norm(VMperp*V_Ut(:,1:rstar));
    
    sigma_min(t)=Sigma_Ut(rstar,rstar);
    
     loss(t)=norm(Ut*Ut'-X*X','fro')^2/loss_zero;
    
    Zttilde=reshape(A'*(-y),[d,d]);
    Xttilde = Uttilde*Uttilde' ;
    Zttilde=1/2*(transpose(Zttilde)+Zttilde);
    Uttilde=Uttilde-mu*Zttilde*Uttilde ;
    [V_Uttilde,Sigma_Uttilde,W_Uttilde] = svd(Uttilde,'econ');
    angle_tilde(t)=norm(VMperp*V_Uttilde(:,1:rstar));
  
    
    
 
    
end
dlmwrite('sigma_min.csv',[transpose(1:iters), sigma_min], ' ')
dlmwrite('angle_tilde.csv',[transpose(1:iters), angle_tilde], ' ')
dlmwrite('angle.csv',[transpose(1:iters), angle], ' ')
dlmwrite('loss.csv',[transpose(1:iters), loss], ' ')
dlmwrite('first_line.csv',[20 0; 20 0.5; 20 1], ' ')
dlmwrite('second_line.csv',[45 0; 45 0.5; 45 1], ' ')