clear all;
close all;
clc      ;

d = 200      ;
rstar = 5      ;
X = zeros(d) ;
U = orth(randn(d,rstar));
X = U*U' ; 

m = 10*d*rstar ;

A = randn(m,d^2) ;


y = A*X(:) ;

nu = 1/(70*d^2);

R_choices=[5,10,20,40,100,200,400];
iters=200;

angle=zeros(iters,length(R_choices));
sigma_min=zeros(iters,length(R_choices));
loss=zeros(iters,length(R_choices));

for i=1:length(R_choices)
r=R_choices(i);
Ut = nu*(1/sqrt(r))*randn(d,r);
Xt = Ut*Ut' ;

mu = 1/(4*m);


M=(1/m)*reshape(A'*(A*X(:)),[d,d]);
M=1/2*(M+transpose(M));
[V_M,Sigma_M,W_M] = svd(M);

VMperp=transpose(V_M(:,(rstar+1):d));
angle_tilde=zeros(iters,1);
for t = 1 : iters
 
    Zt=reshape(A'*(A*Xt(:)-y),[d,d]);
    Xt = Ut*Ut' ;
    Zt=1/2*(transpose(Zt)+Zt);
    Ut = Ut-mu*Zt*Ut ;
    [V_Ut,Sigma_Ut,W_Ut] = svd(Ut);    
    
    angle(t,i)=norm(VMperp*V_Ut(:,1:rstar));   
    sigma_min(t,i)=Sigma_Ut(rstar,rstar);
    loss(t,i)=norm(Xt-X,'fro')/norm(X,'fro');
end
end

dlmwrite('angle1.csv',[transpose(1:iters), angle(1:iters,1)], ' ')
dlmwrite('angle2.csv',[transpose(1:iters), angle(1:iters,2)], ' ')
dlmwrite('angle3.csv',[transpose(1:iters), angle(1:iters,3)], ' ')
dlmwrite('angle4.csv',[transpose(1:iters), angle(1:iters,4)], ' ')
dlmwrite('angle5.csv',[transpose(1:iters), angle(1:iters,5)], ' ')
dlmwrite('angle6.csv',[transpose(1:iters), angle(1:iters,6)], ' ')
dlmwrite('angle7.csv',[transpose(1:iters), angle(1:iters,7)], ' ')

dlmwrite('sigma_min1.csv',[transpose(1:iters), sigma_min(1:iters,1)], ' ')
dlmwrite('sigma_min2.csv',[transpose(1:iters), sigma_min(1:iters,2)], ' ')
dlmwrite('sigma_min3.csv',[transpose(1:iters), sigma_min(1:iters,3)], ' ')
dlmwrite('sigma_min4.csv',[transpose(1:iters), sigma_min(1:iters,4)], ' ')
dlmwrite('sigma_min5.csv',[transpose(1:iters), sigma_min(1:iters,5)], ' ')
dlmwrite('sigma_min6.csv',[transpose(1:iters), sigma_min(1:iters,6)], ' ')
dlmwrite('sigma_min7.csv',[transpose(1:iters), sigma_min(1:iters,7)], ' ')

dlmwrite('loss1.csv',[transpose(1:iters), loss(:,1)], ' ')
dlmwrite('loss2.csv',[transpose(1:iters), loss(:,2)], ' ')
dlmwrite('loss3.csv',[transpose(1:iters), loss(:,3)], ' ')
dlmwrite('loss4.csv',[transpose(1:iters), loss(:,4)], ' ')
dlmwrite('loss5.csv',[transpose(1:iters), loss(:,5)], ' ')
dlmwrite('loss6.csv',[transpose(1:iters), loss(:,6)], ' ')
dlmwrite('loss7.csv',[transpose(1:iters), loss(:,7)], ' ')

