clear all;
close all;
clc      ;

%syms x y

n = 100 ;

[xx,yy]=meshgrid(-1.5:0.05:1.5,-1.5:0.05:1.5) ;

theta     = [ xx(:).' ; yy(:).' ] ;
thetastar = [ ones(1,size(theta,2)) ; zeros(1,size(theta,2)) ] ;
%A=randn(n,2);
sample_size=15;
A = randn(2,2,sample_size) ;

%y     =  A*theta     ;
%ystar =  A*thetastar ;

%grad = 1/n*A.'*((sign(y)).*(abs(y)-abs(ystar))) ;
%grad =-(thetastar*transpose(thetastar)-theta*transpose(theta))*theta;

grad=zeros(2,3721);
for j=1:3721
for i=1:sample_size
    grad(:,j)=grad(:,j)-A(:,:,i)*theta(:,j)*trace(A(:,:,i)*(thetastar(:,j)*transpose(thetastar(:,j))-theta(:,j)*transpose(theta(:,j))));
end
end


u = reshape(grad(1,:),size(xx));
v = reshape(grad(2,:),size(xx));
%XY = streamline(xx,yy,u,v) ;

h= streamslice(xx,yy,-u,-v)
set(h,'Linewidth',2);

hold on
%plot(0,2/pi,'bo','MarkerSize',20,'MarkerFaceColor','red')
%plot(0,-2/pi,'bo','MarkerSize',20,'MarkerFaceColor','red')

plot(0,0,'bo','MarkerSize',20,'MarkerFaceColor','yellow')

plot(1,0,'bo','MarkerSize',20,'MarkerFaceColor','green')
plot(-1,0,'bo','MarkerSize',20,'MarkerFaceColor','green')

set(gca,'Fontsize',20)
%load wind
%zmax = max(z(:)); zmin = min(z(:));
%streamslice(x,y,z,u,v,w,[],[],(zmax-zmin)/2)

