import torch.nn as nn
import torch.nn.functional as F


class LinearModel(nn.Module):
    def __init__(self, hidden_size, input_size, output_size):
        super(LinearModel, self).__init__()
        self.fc1 = nn.Linear(input_size, output_size)

    def forward(self, x):
        x = self.fc1(x)
        return x


class NonLinearModel(nn.Module):
    def __init__(self, hidden_size, input_size, output_size):
        super(NonLinearModel, self).__init__()
        self.l1 = nn.Linear(input_size, hidden_size)
        self.l3 = nn.Linear(hidden_size, output_size)

    def forward(self, x):
        x = F.relu(self.l1(x))
        x = self.l3(x)
        return x
