import torch.nn as nn
import torch.nn.functional as F


class LinearModel(nn.Module):
    def __init__(self, hidden_size, input_size, output_size):
        super(LinearModel, self).__init__()
        self.fc1 = nn.Linear(input_size, output_size)

    def forward(self, x):
        x = self.fc1(x)
        return x


class NonLinearModel(nn.Module):
    def __init__(self, hidden_size, input_size, output_size):
        super(NonLinearModel, self).__init__()
        self.l1 = nn.Linear(input_size, hidden_size)
        self.l2 = nn.Linear(hidden_size, 8)
        self.l3 = nn.Linear(8, hidden_size)
        self.l4 = nn.Linear(hidden_size, output_size)

    def forward(self, x):
        x = F.elu(self.l1(x))
        x = F.elu(self.l2(x))
        x = F.elu(self.l3(x))
        x = self.l4(x)
        return x
