# Differentially Private SGDA for a class of Minimax Problems
[![Python](https://img.shields.io/badge/python-3.6-blue.svg)](https://www.python.org/)

_________________

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## How to calculate sigma
Given eps, delta, training size, epoch, and batch size, then run the following code. 
```test
  python calculate_sigma.py
```

## How to run SGDA and DP-SGDA with linear setting on three datasets

### 1. Run SGDA and DP-SGDA with linear setting on ijcnn1
#### a. Run SGDA with linear setting on ijcnn1
```test
  python main_AUC_Linear_ijcnn1.py
```
#### b. Run DP-SGDA with linear setting on ijcnn1
```test
  python main_AUC_Linear_ijcnn1_autodp.py
```
### 2. Run SGDA and DP-SGDA with linear setting on MNIST
#### a. Run SGDA with linear setting on MNIST
```test
  python main_AUC_Linear_mnist.py
```
#### b. Run DP-SGDA with linear setting on MNIST
```test
  python main_AUC_Linear_mnist_autodp.py
```
### 3. Run SGDA and DP-SGDA with linear setting on Fashion-MNIST
#### a. Run SGDA with linear setting on Fashion-MNIST
```test
  python main_AUC_Linear_fashionmnist.py
```
#### b. Run DP-SGDA with linear setting on Fashion-MNIST
```test
  python main_AUC_Linear_fashionmnist_autodp.py
```

## How to run SGDA and DP-SGDA with MLP setting on three datasets

### 1. Run SGDA and DP-SGDA with MLP setting on ijcnn1
#### a. Run SGDA with MLP setting on ijcnn1
```test
  python main_AUC_MLP_ijcnn1.py
```
#### b. Run DP-SGDA with MLP setting on ijcnn1
```test
  python main_AUC_MLP_ijcnn1_autodp.py
```
### 2. Run SGDA and DP-SGDA with MLP setting on MNIST
#### a. Run SGDA with MLP setting on MNIST
```test
  python main_AUC_MLP_mnist.py
```
#### b. Run DP-SGDA with MLP setting on MNIST
```test
  python main_AUC_MLP_mnist_autodp.py
```
### 3. Run SGDA and DP-SGDA with MLP setting on Fashion-MNIST
#### a. Run SGDA with MLP setting on Fashion-MNIST
```test
  python main_AUC_MLP_fashionmnist.py
```
#### b. Run DP-SGDA with MLP setting on Fashion-MNIST
```test
  python main_AUC_MLP_fashionmnist_autodp.py
```

## How to run NSEG-nondp and NSEG with linear setting on three datasets

### 1. Run NSEG-nondp and NSEG with linear setting on ijcnn1
#### a. Run NSEG-nondp with linear setting on ijcnn1
```test
  python main_AUC_NSEG_Linear_ijcnn1.py
```
#### b. Run NSEG with linear setting on ijcnn1
```test
  python main_AUC_NSEG_Linear_ijcnn1_autodp.py
```
### 2. Run NSEG-nondp and NSEG with linear setting on MNIST
#### a. Run NSEG-nondp with linear setting on MNIST
```test
  python main_AUC_NSEG_Linear_mnist.py
```
#### b. Run NSEG with linear setting on MNIST
```test
  python main_AUC_NSEG_Linear_mnist_autodp.py
```
### 3. Run NSEG-nondp and NSEG with linear setting on Fashion-MNIST
#### a. Run NSEG-nondp with linear setting on Fashion-MNIST
```test
  python main_AUC_NSEG_Linear_fashionmnist.py
```
#### b. Run NSEG with linear setting on Fashion-MNIST
```test
  python main_AUC_NSEG_Linear_fashionmnist_autodp.py
```

## How to plot Figure 1 (a) in our paper
```test
python plot_noise_in_general_performance.py
```

## How to plot Figure 1 (b) in our paper
Setting different batch size and run
###1. without dp
```test
python main_AUC_MLP_ijcnn1_diff_hid.py
python main_AUC_MLP_mnist_diff_hid.py
python main_AUC_MLP_fashionmnist_diff_hid.py
```
###2. with dp
```test
python main_AUC_MLP_ijcnn1_diff_hid_autodp.py
python main_AUC_MLP_mnist_diff_hid_autodp.py
python main_AUC_MLP_fashionmnist_diff_hid_autodp.py
```
###3. Plot
```test
python plot_diff_hidden_units.py
```

## How to plot Figure 1 (c) in our paper
```test
python plot_diff_batch_size.py
```