import numpy as np
from sklearn.metrics import roc_auc_score
from autodp.calibrator_zoo import eps_delta_calibrator,generalized_eps_delta_calibrator, ana_gaussian_calibrator
from autodp import rdp_bank
from autodp.mechanism_zoo import ExactGaussianMechanism, PureDP_Mechanism,SubsampleGaussianMechanism, GaussianMechanism, ComposedGaussianMechanism, LaplaceMechanism
from autodp.transformer_zoo import Composition, AmplificationBySampling

####autodp parameters
eps_list = [1]
delta_list=[1e-6]
training_size = 39992
epoch = 15
batch_size = [16, 32, 128, 256]
for eps in eps_list:
    for delta in delta_list:
        for bs in batch_size:
            general_calibrate = generalized_eps_delta_calibrator()
            params = {}
            params['sigma'] = None
            params['coeff'] = epoch*training_size/bs ### number of iterations
            params['prob'] = bs/training_size  #### 1/number of data points
            mech4 = general_calibrate(SubsampleGaussianMechanism, eps, delta, [0, 1000], params=params, para_name='sigma',
                                      name='Subsampled_Gaussian')
            print(eps, delta, mech4.params)