import matplotlib.pyplot as plt
import matplotlib
import time
import scipy.io
import numpy as np


x=[16, 32, 64, 128, 256]

values=[16, 32, 64, 128, 256]

y_mnist_DP_SGDA_MLP=[97.971, 98.745, 98.705, 98.132, 97.083]
y_ijcnn1_DP_SGDA_MLP=[92.263, 95.554, 96.167, 95.111, 93.058]
y_fmnist_DP_SGDA_MLP=[96.629, 96.803, 97.102, 96.779, 96.248]

y_mnist_DP_SGDA_Linear=[92.715, 92.610, 92.070, 91.339, 90.369]
y_ijcnn1_DP_SGDA_Linear=[90.540, 91.462, 91.371, 91.062, 89.666]
y_fmnist_DP_SGDA_Linear=[95.539, 95.998, 95.834, 95.512, 95.070]

# y_mnist_NSEG=[92.463, 92.039, 91.330, 90.422, 90.309]
# y_ijcnn1_NSEG=[88.821, 91.679, 90.355, 90.066, 89.407]
# y_fmnist_NSEG=[95.813, 95.810, 95.534, 95.059, 94.511]


fig = plt.figure()
plt.plot(x,y_mnist_DP_SGDA_MLP, color='r', linestyle='-', label = 'MNIST_DP-SGDA_MLP',lw = 2)
plt.plot(x,y_mnist_DP_SGDA_Linear, color='r', linestyle=':', label = 'MNIST_DP-SGDA_Linear',lw = 2)
# plt.plot(x,y_mnist_NSEG, color='r', linestyle=':', label = 'MNIST_NSEG',lw = 2)
plt.plot(x,y_ijcnn1_DP_SGDA_MLP, color='b', linestyle='-', label = 'ijcnn1_DP-SGDA_MLP',lw = 2)
plt.plot(x,y_ijcnn1_DP_SGDA_Linear, color='b', linestyle=':', label = 'ijcnn1_DP-SGDA_Linear',lw = 2)
# plt.plot(x,y_ijcnn1_NSEG, color='b', linestyle=':', label = 'ijcnn1_NSEG',lw = 2)
plt.plot(x,y_fmnist_DP_SGDA_MLP, color='g', linestyle='-', label = 'Fashion-MNIST_DP-SGDA_MLP',lw = 2)
plt.plot(x,y_fmnist_DP_SGDA_Linear, color='g', linestyle=':', label = 'Fashion-MNIST_DP-SGDA_Linear',lw = 2)
# plt.plot(x,y_fmnist_NSEG, color='g', linestyle=':', label = 'Fashion-MNIST_NSEG',lw = 2)
plt.legend(prop={'size': 12, 'weight':'bold'}, loc='lower center')
# plt.yscale('log',base=10)
plt.xticks(x,values)
plt.xlabel(r'Batch Size', fontsize=15)
plt.ylabel(r'AUC(%)', fontsize=15)
plt.text(20, 82, r'$\bf{(c)}$', fontsize=15)
plt.ylim((80, 100))
# plt.xlim((64, 1024))
plt.show()
fig.savefig('./fig/{}.pdf'.format('diff_batch_size_eps1_delta-6'), bbox_inches='tight', pad_inches = 0)


 
 

