import matplotlib.pyplot as plt
import matplotlib
import time
import scipy.io
import numpy as np


x=[64, 128, 256, 512, 1024]

values=[64, 128, 256, 512, 1024]

y_mnist=[99.440, 99.515, 99.564, 99.547, 99.575]
y_ijcnn1=[95.922, 96.23, 96.609, 96.801, 96.787]
y_fmnist=[97.970, 98.040, 98.020, 98.077, 98.135]

y_mnist_dp=[98.721, 98.705, 98.705, 98.696, 95.488]
y_ijcnn1_dp=[95.872, 96.113, 96.167, 93.568, 89.279]
y_fmnist_dp=[97.187, 97.123, 97.102, 97.133, 95.496]


fig = plt.figure()
plt.plot(x,y_mnist_dp, color='r', linestyle='-', label = 'MNIST_DP-SGDA',lw = 2)
plt.plot(x,y_ijcnn1_dp, color='b', linestyle='-', label = 'ijcnn1_DP-SGDA',lw = 2)
plt.plot(x,y_fmnist_dp, color='g', linestyle='-', label = 'Fashion_DP-SGDA',lw = 2)
plt.plot(x,y_mnist, color='r', linestyle=':', label = 'MNIST_SGDA',lw = 2)
plt.plot(x,y_ijcnn1, color='b', linestyle=':', label = 'ijcnn1_SGDA',lw = 2)
plt.plot(x,y_fmnist, color='g', linestyle=':', label = 'Fashion_SGDA',lw = 2)
plt.legend(prop={'size': 12, 'weight':'bold'}, loc='lower center')
# plt.yscale('log',base=10)
plt.xticks(x,values)
plt.xlabel(r'Hidden Units', fontsize=15)
plt.ylabel(r'AUC(%)', fontsize=15)
plt.text(64, 82, r'$\bf{(b)}$', fontsize=15)
plt.ylim((80, 100))
# plt.xlim((64, 1024))
plt.show()
fig.savefig('./fig/{}.pdf'.format('diff_hidden_units_eps1_delta-6'), bbox_inches='tight', pad_inches = 0)


 
 

