# SIMULATION
DEFAULT_MAX_STEPS = 300
DEFAULT_MAX_ERRORS = 10
DEFAULT_SEED = 300
DEFAULT_MAX_CONCURRENCY = 1
DEFAULT_NUM_TRIALS = 1
DEFAULT_SAVE_TO = None
DEFAULT_LOG_LEVEL = "DEBUG"
DEFAULT_LANGUAGE = "chinese"
DEFAULT_EVALUATION_TYPE = "trajectory"
DEFAULT_ENABLE_THINK = False
DEFAULT_ENABLE_MEMORY = False

# Default API configuration
DEFAULT_API_URL = "https://api.toiotech.com/v1/chat/completions"
DEFAULT_API_KEY = "xxx"
DEFAULT_HEADERS = {
    "Accept": "*/*",
    "Accept-Encoding": "gzip, deflate, br",
    "Content-Type": "application/json",
    "Authorization": f"Bearer {DEFAULT_API_KEY}",
    "Connection": "keep-alive",
    "Cookie": "xxx",
    "User-Agent": "PostmanRuntime-ApipostRuntime/1.1.0'"
}

DEFAULT_LLM_USER_BASE_URL = DEFAULT_API_URL
DEFAULT_LLM_USER = "gpt-4.1"
DEFAULT_LLM_ARGS_USER = {
    "base_url": DEFAULT_LLM_USER_BASE_URL, 
    "api_key": DEFAULT_API_KEY, 
    "extra_headers": DEFAULT_HEADERS, 
    "temperature": 0.0,
    "max_tokens": 8192,
    "max_input_tokens": 16384,
}

DEFAULT_LLM_AGENT_BASE_URL = DEFAULT_API_URL
DEFAULT_LLM_AGENT = "gpt-4.1"

DEFAULT_LLM_ARGS_AGENT = {
    "base_url": DEFAULT_LLM_AGENT_BASE_URL,
    "api_key": DEFAULT_API_KEY,
    "extra_headers": DEFAULT_HEADERS,
    "temperature": 0.0,
    "max_tokens": 4096,
    "max_input_tokens": 32768
}

DEFAULT_MEMORY_LLM = "gpt-4.1"
DEFAULT_MEMORY_LLM_ARGS = {
    "base_url": DEFAULT_LLM_AGENT_BASE_URL,
    "api_key": DEFAULT_API_KEY,
    "extra_headers": DEFAULT_HEADERS,
    "temperature": 0.0,
    "max_tokens": 2048,
    "max_input_tokens": 32768,
}


DEFAULT_LLM_EVALUATOR = "claude-3-7-sonnet-20250219"
DEFAULT_LLM_EVALUATOR_BASE_URL = DEFAULT_API_URL
DEFAULT_LLM_EVALUATOR_ARGS = {
    "base_url": DEFAULT_LLM_EVALUATOR_BASE_URL, 
    "api_key": DEFAULT_API_KEY, 
    "extra_headers": DEFAULT_HEADERS, 
    "temperature": 0.0, 
    "max_tokens": 32768,
    "max_input_tokens": 200000,
}

# LLM
DEFAULT_AGENT_IMPLEMENTATION = "llm_agent"
DEFAULT_USER_IMPLEMENTATION = "user_simulator"
DEFAULT_LLM_TEMPERATURE_AGENT = 0.0
DEFAULT_LLM_TEMPERATURE_USER = 0.0
DEFAULT_LLM_NL_ASSERTIONS_TEMPERATURE = 0.0

# LITELLM
DEFAULT_MAX_RETRIES = 3
LLM_CACHE_ENABLED = False
DEFAULT_LLM_CACHE_TYPE = "redis"

# REDIS CACHE
REDIS_HOST = "localhost"
REDIS_PORT = 6379
REDIS_PASSWORD = ""
REDIS_PREFIX = "vita"
REDIS_CACHE_VERSION = "v1"
REDIS_CACHE_TTL = 60 * 60 * 24 * 30

# LANGFUSE
USE_LANGFUSE = False  # If True, make sure all the env variables are set for langfuse.

# API
API_PORT = 8000
