import json

import pytest

from vita.run import get_tasks
from vita.utils import DATA_DIR
from vita.utils.utils import get_hash, show_dict_diff


@pytest.fixture
def base_task_name() -> str:
    return "create_task_1"





@pytest.fixture
def tasks_dict():
    task_file = DATA_DIR / "vita" / "domains" / "mock" / "tasks.json"
    with open(task_file, "r") as f:
        task_dicts = json.load(f)
    tasks_dict = {v["id"]: v for v in task_dicts}
    return tasks_dict


def test_get_task_base(base_task_name: str, tasks_dict: dict):
    task_dict = tasks_dict[base_task_name]
    task_instance = get_tasks("mock", task_ids=[base_task_name])[0]
    task_instance_dict = task_instance.model_dump(
        exclude_unset=True, exclude_defaults=True, exclude_none=True
    )
    print(show_dict_diff(task_dict, task_instance_dict))
    assert get_hash(task_dict) == get_hash(task_instance_dict)



