import torch
import torch.nn as nn


class Model(nn.Module):
    def __init__(self, num_inputs=2, num_features=16, num_outputs=1):
        super().__init__()
        self.model = nn.Sequential(
            nn.Conv3d(num_inputs, num_features, 3, padding='same'),
            nn.SiLU(),
            nn.Conv3d(num_features, num_features, 3, padding='same'),
            nn.SiLU(),
            nn.Conv3d(num_features, num_outputs, 3, padding='same'),
        )

    def forward(self, x):
        x = x.permute(1, 2, 0, 3, 4)    # batch, channel, time, height, width
        y = self.model(x)
        y = y.permute(2, 0, 1, 3, 4)
        return y


model = Model()
x = torch.randn(50, 1, 2, 8, 8)
print(x.shape)

y = model(x)
print(y.shape)
