# Heavy-Ball Momentum Method in Continuous Time and Discretization Error Analysis

This paper establishes a continuous time approximation, a piece-wise continuous differential equation, for the discrete Heavy-Ball (HB) momentum method with explicit discretization error. Investigating continuous differential equations has been a promising approach for studying the discrete optimization methods. 
Despite the crucial role of momentum in gradient-based optimization methods, the gap between the original discrete dynamics and the continuous time approximations due to the discretization error has not been comprehensively bridged yet. In this work, we study the HB momentum method in continuous time while putting more focus on the discretization error to provide additional theoretical tools to this area. In particular, we design a first-order piece-wise continuous differential equation, where we add a number of counter terms to account for the discretization error explicitly. As a result, we provide a continuous time model for the HB momentum method that allows the control of discretization error to *arbitrary order* of the step size. As an application, we leverage it to find a new implicit regularization of the directional smoothness and investigate the implicit bias of HB for diagonal linear networks, indicating how our results can be used in deep learning. Our theoretical findings are further supported by numerical experiments.


## Numerical Experiments

### 1. Implicit regularization of HBF (directional smoothness)

- Figure 1: directional_smoothness.ipynb

### 2. A simple 2-d model to verify our theoretical claims

- Figure 2: 2d_exp_uvexp_alignketa.ipynb
- Diff Euler: 2d_exp_uvexp_diff_euler.ipynb

### 3. Discretization error for different approximations

- Figure 3: hbf_dln_error.ipynb

### 4. Implication for difference of implicit bias between HB and GD

- Figure 4 (a): dln_ib.ipynb
- Figure 4 (b): hbf_torch.ipynb

## 5. More experiments on deep learning taskes for the discretization errors

- mlp_mnist_diff_mu_disc_error.py
- scripts_mlp_mnist_diff_mu_disc_error.sh
- plot_mlp_mnist_diff_mu_disc_error.ipynb

