# Universality and Label Efficiency Trade-off

## Running Experiments

### Training

An example to train a MoCo v2 model. Just need to change the config file `moco_cifar_pretrain.yaml`.

`python main.py --data_dir ./data/ --log_dir ./logs/ --config-file ./configs/moco_cifar_pretrain.yaml --ckpt_dir ./checkpoints/ --download --hide_progress --save_interval 10`

An example to continue training from a checkpoint.

`python main.py --data_dir ./data/ --log_dir ./logs/ --config-file ./configs/moco_cifar_pretrain.yaml --ckpt_dir ./checkpoints/ --download --hide_progress --save_interval 10 --start_epoch {number} --save_dir checkpoints/{ckp_dir}`

### Evaluation

#### Linear Probing

`python linear_eval.py --config-file ./configs/moco_cifar_eval_sgd.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --eval_from ./checkpoints/{model_ckpt} --percent 1.0 --hide_progress`

#### Finetune

`python finetune_eval.py --config-file ./configs/moco_cifar_finetune_contrastive_eval.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --eval_from ./checkpoints/{model_ckpt} --percent 1.0 --hide_progress`

#### Finetune + Contrastive Regularization

`python finetune_contrastive_eval.py --config-file ./configs/moco_cifar_finetune_contrastive_eval.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --eval_from ./checkpoints/{model_ckpt} --percent 1.0 --hide_progress`

### CLIP

First, save train, test and augmentation features (Please download the imagenet to the folder `./data/imagenet/`):

`python get_model_feature.py --config-file ./configs/clip_castrate_imagenet.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --hide_progress --start_epoch 0 --end_epoch 5`

#### Linear Probing for CLIP

`python linear_eval.py --config-file ./configs/clip_castrate:ViT-L-14_imagenet_feature_eval_sgd.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --percent 1.0 --hide_progress`

#### Finetune for CLIP

`python finetune_eval.py --config-file ./configs/clip_castrate:ViT-L-14_imagenet_feature_simclr_mlp_eval_sgd.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --percent 1.0 --hide_progress`

#### Finetune + Contrastive Regularization for CLIP

`python finetune_contrastive_eval.py --config-file ./configs/clip_castrate:ViT-L-14_imagenet_feature_simclr_mlp_eval_sgd.yaml --data_dir ./data/ --log_dir ./logs/ --ckpt_dir checkpoints/ --percent 1.0 --hide_progress`
