## Acknowledgments
This code is a fork from the original work of SchNetPack: https://github.com/atomistic-machine-learning/schnetpack 

##### Requirements:
- python 3.8
- Atomic Simulation Environment (ASE) 3.21
- NumPy
- PyTorch 1.9
- PyTorch Lightning 1.9.0
- Hydra 1.1

_**Note: We recommend using a GPU for training the neural networks.**_

## Installation

### Install with pip

```
pip install .
```

## Getting started
 
The best place to get started is training a SchNetPack model on a common benchmark dataset via the command line
interface (CLI).
When installing SchNetPack, the training script `spktrain` is added to your PATH.
The CLI is based on [Hydra](https://hydra.cc/) and oriented on the PyTorch Lightning/Hydra template that can be found
[here](https://github.com/ashleve/lightning-hydra-template).
This enables a flexible configuration of the model, data and training process.
To fully take advantage of these features, it might be helpful to have a look at the Hydra and PyTorch Lightning docs.

### Training MoreRed
Training MoreRed-JT on QM7-X
```
spktrain experiment=qm7x_diffusion_eq_time
```
- The other experiments, e.g. on QM9 or force field model training, can be found under configs/experiments.
- For force field model training refer to the original repository of SchnetPack for more details.
- All the necessary code is under src/schnetpack/diffusion and src/schnetpack/configs
- Under src/schnetpack/diffusion/utils.py are helpers to sample from DDPM (function sample_R)
or to sample from MoreRed (function sample_R_time)
- the scripts denoise.py , optimize_forces.py  under src/schnetpack/diffusion can be used for structure relaxation
- As this work uses and builds on top of the SchNetPack library More details about the code structure and how to use the library can be found in the original repository

### MoreRed with images
The notebook ./images.ipynb has the necessary code for small experiments with images and analysis.
The script ./images.py can be used for training:
```
python3 images.py <experiment> <cond>
```
with experiment in ['cifar', 'mnist'] and cond in ['cond', 'pred']. use 'cond' to train DDPM and 'pred' for MoreRed


