#!/bin/bash

gpu_list="${CUDA_VISIBLE_DEVICES:-0}"
IFS=',' read -ra GPULIST <<< "$gpu_list"

CHUNKS=${#GPULIST[@]}

CKPT="llava-squential-v1.5-7b-vicuna-chartqa"
SPLIT="chartqa_val"

for IDX in $(seq 0 $((CHUNKS-1))); do
    CUDA_VISIBLE_DEVICES=${GPULIST[$IDX]} python -m llava.eval.model_vqa_loader \
        --model-path ./output/llava-squential-v1.5-7b-vicuna-chartqa \
        --question-file ./playground/data/eval/chartqa/$SPLIT.jsonl \
        --image-folder ./playground/data \
        --answers-file ./playground/data/eval/chartqa/answers/$SPLIT/$CKPT/${CHUNKS}_${IDX}.jsonl \
        --num-chunks $CHUNKS \
        --chunk-idx $IDX \
        --temperature 0 \
        --conv-mode vicuna_v1 &
done

# --model-path liuhaotian/llava-v1.5-7b

wait

output_file=./playground/data/eval/chartqa/answers/$SPLIT/$CKPT/merge.jsonl

# Clear out the output file if it exists.
> "$output_file"

# Loop through the indices and concatenate each file.
for IDX in $(seq 0 $((CHUNKS-1))); do
    cat ./playground/data/eval/chartqa/answers/$SPLIT/$CKPT/${CHUNKS}_${IDX}.jsonl >> "$output_file"
done

python scripts/convert_chartqa_for_submission.py --split $SPLIT --ckpt $CKPT --dir ./playground/data/eval/chartqa

# python scripts/convert_vqav2_for_submission.py --split $SPLIT --ckpt $CKPT --dir ./playground/data/eval/chartqa