#!/bin/bash

gpu_list="${CUDA_VISIBLE_DEVICES:-0}"
IFS=',' read -ra GPULIST <<< "$gpu_list"

CHUNKS=${#GPULIST[@]}

CKPT="continual-llava-odlastfulltuning-mask-newtask-referring_qa-detail_description-complex_reasoning-conversation"
SPLIT="detail_description_val"

for IDX in $(seq 0 $((CHUNKS-1))); do
    echo '=============================='
    echo 'CHUNKS: '$CHUNKS', IDX: '$IDX', GPU: '${GPULIST[$IDX]}
    echo '=============================='
    CUDA_VISIBLE_DEVICES=${GPULIST[$IDX]} python -m llava.eval.model_vqa_loader \
        --model-path ./output/$CKPT \
        --question-file ./playground/data/eval/detail_description/$SPLIT.jsonl \
        --image-folder ./playground/data \
        --answers-file ./playground/data/eval/detail_description/answers/$SPLIT/$CKPT/${CHUNKS}_${IDX}.jsonl \
        --num-chunks $CHUNKS \
        --chunk-idx $IDX \
        --temperature 0 \
        --conv-mode vicuna_v1 &
done

# --model-path liuhaotian/llava-v1.5-7b

wait

output_file=./playground/data/eval/detail_description/answers/$SPLIT/$CKPT/merge.jsonl

# Clear out the output file if it exists.
> "$output_file"

# Loop through the indices and concatenate each file.
for IDX in $(seq 0 $((CHUNKS-1))); do
    cat ./playground/data/eval/detail_description/answers/$SPLIT/$CKPT/${CHUNKS}_${IDX}.jsonl >> "$output_file"
done

python scripts/convert_chartqa_for_submission.py --split $SPLIT --ckpt $CKPT --dir ./playground/data/eval/detail_description

# python scripts/convert_vqav2_for_submission.py --split $SPLIT --ckpt $CKPT --dir ./playground/data/eval/chartqa