# All-Alive Pruning

Official code for **Waste not, Want not: All-Alive Pruning for Extremely Lightweight Networks**

## Pre-trained models (LeNet-300-100)


Accuracy of LeNet-300-100 on MNIST under a variety of compression ratios. (All results are average of 3 trials)

| Compression Ratio                               | 64x   | 128x  | 256x  | 512x  |
|-------------------------------------------|-------|-------|-------|-------|
| Iterative Magnitude Pruning                | 97.27  | 96.07 | 92.01 | 82.43 |
| Iterative Magnitude Pruning + AAP     | 97.31 | 96.20 | 93.55 | 91.50 |

- 128x Compression Ratio: [IMP-AAP](pretrained/lenet-300-100/lenet_300_100_128x_IMP_AAP.pt) / [IMP](pretrained/lenet-300-100/lenet_300_100_128x_IMP.pt)
- 256x Compression Ratio: [IMP-AAP](pretrained/lenet-300-100/lenet_300_100_256x_IMP_AAP.pt) / [IMP](pretrained/lenet-300-100/lenet_300_100_256x_IMP.pt)
- 512x Compression Ratio: [IMP-AAP](pretrained/lenet-300-100/lenet_300_100_512x_IMP_AAP.pt) / [IMP](pretrained/lenet-300-100/lenet_300_100_512x_IMP.pt)


## Dependencies

This project requires PyTorch 1.4.<br>
You can pull the corresponding docker image with the below command.

    docker pull pytorch/pytorch:1.4-cuda10.1-cudnn7-runtime

---

## Dataset

You should specify the location of the dataset by *data-dir* argument.

---

This code uses the multi-GPU by default.
Add *single-gpu* option for single-GPU environment.

## Train Base Model

NOTE: This code supports the below (dataset - model) pairs.
Change the dataset and arch arguments in the command.

- **mnist**: lenet
- **cifar10**: resnet32, resnet18
- **tiny-imagenet**: resnet50, mobilenetv2, efficientnet-b0

### Trian unpruned model (Base model)

    # Train LeNet on MNIST
    python train.py \
        --seed 1 \
        --mode train \
        --dataset mnist \
        --arch lenet \
        --data-dir <DATA_DIR> \
        --save-dir <SAVE_DIR>
    
    # Train ResNet-18 on CIFAR-10
    python train.py \
        --seed 1 \
        --mode train \
        --dataset cifar10 \
        --arch resnet18 \
        --data-dir <DATA_DIR> \
        --save-dir <SAVE_DIR>


---

## AAP

The pruning percentage is determined by 1 - (1- prune-percent)^(pruning-step).
(If prune-percent=50, pruning-step=2, 87.5% of the parameters will be pruned)<br>
It was motivated by iterative pruning with prune-percent.

You can apply AAP by adding *all-alive-pruning* argument.

### 1. AAP with Magnitude Pruning + Learning rate rewinding (ResNet-50)

Check the list of arguments in train.py for more options. You can test the settings of *the lottery ticket hypothesis* by setting the initialization value of the network to the original network's initial weights.

    python train.py \
        --seed 1 \
        --all-alive-pruning \
        --rewinding lr \
        --mode prune \
        --dataset tiny-imagenet \
        --arch resnet50 \
        --save-dir <SAVE_DIR> \
        --data-dir <DATA_DIR> \
        --origin-best-path <ORIGIN_BEST_PATH> \
        --origin-init-path <ORIGIN_INIT_PATH> \
        --prune-percent 50 \
        --pruning-step 1 \
        --prune-method mp

### 2. AAP with IMP (Iterative MP) + Learning rate rewinding (ResNet-18)

It automatically prunes the network by *prune-percent* for each step.

    for ((i=1;i<=10;i+=1));
    do
    python train.py \
        --seed 1 \
        --all-alive-pruning \
        --rewinding lr \
        --mode prune \
        --dataset cifar10 \
        --arch resnet18 \
        --save-dir <SAVE_DIR> \
        --data-dir <DATA_DIR> \
        --origin-best-path <ORIGIN_BEST_PATH> \
        --origin-init-path <ORIGIN_INIT_PATH> \
        --prune-percent 50 \
        --pruning-step 1 \
        --prune-method mp \
        --imp \
        --imp-metric '120epoch' \
        --imp-from '120epoch' \
        --imp-index $i
    done

### 3. AAP with SNIP (LeNet-300-100)

    python train.py \
        --seed 1 \
        --all-alive-pruning \
        --mode prune \
        --dataset mnist \
        --arch lenet \
        --save-dir <SAVE_DIR> \
        --data-dir <DATA_DIR> \
        --prune-percent 50 \
        --pruning-step 1 \
        --prune-method snip

### 4. AAP with LAP (LeNet-300-100)

    python train.py \
        --seed 1 \
        --all-alive-pruning \
        --mode prune \
        --dataset mnist \
        --arch lenet \
        --save-dir <SAVE_DIR> \
        --data-dir <DATA_DIR> \
        --origin-best-path <ORIGIN_BEST_PATH> \
        --origin-init-path <ORIGIN_INIT_PATH> \
        --prune-percent 50 \
        --pruning-step 1 \
        --prune-method lap

## Evaluation

    # Evaluation on LeNet-300-100
    python train.py \
        --mode eval \
        --dataset mnist \
        --arch lenet \
        --data-dir <DATA_DIR> \
        --model-path <MODEL_PATH>

    # Evaluation on ResNet-50
    python train.py \
        --mode eval \
        --dataset tiny-imagenet \
        --arch resnet50 \
        --data-dir <DATA_DIR> \
        --model-path <MODEL_PATH>
