"""Common definitions for foundation ts modules.

Includes date feature dictionaries and granularity mappings.
"""

import dataclasses
import enum

import immutabledict


# Common padding token used to pad all numerical objects when needed.
PAD_VAL = 1123581321.0

DATE_FEATURE_DICT = immutabledict.immutabledict({
    'hour_of_day': 24.0,
    'minute_of_hour': 60.0,
    'month': 12.0,
    'second_of_minute': 60.0,
    'day_of_week': 7.0,
})

NAME_VALUES = 'values'
NAME_FRONT_PAD = 'front_pad'
NAME_INPUT_PADDING = 'input_padding'
NAME_DATE_FEATURES = 'date_features'
NAME_FREQ = 'freq'
NAME_MU = 'mu'
NAME_SIGMA = 'sigma'
NAME_A = 'a'


@enum.unique
class RevinType(str, enum.Enum):
  """Different types of reversible instance normalizations."""

  # no revin.
  NA = 'NA'
  # renormalize and apply loss
  RENORMED = 'RENORMED'
  # apply loss to normalized output
  NORMED = 'NORMED'


@enum.unique
class Frequency(int, enum.Enum):
  """Frequencies of time series."""

  UNKNOWN = 0
  MINUTE = 1
  MINUTE_10 = 2
  MINUTE_15 = 3
  HOUR = 4
  DAY = 5
  WEEK = 6
  MONTH = 7
  QUARTER = 8
  YEAR = 9


@dataclasses.dataclass(frozen=True)
class SimpleDataset:
  """Dataset of pre-processed (windowed and scaled) time series values."""

  file_pattern: str
  time_len: int
  frequency: Frequency = Frequency.UNKNOWN
  chunked: bool = False
  num_chunks: int = 1


SIMPLE_DATASETS = immutabledict.immutabledict({
  # Dict of training datasets
})