

## Parallel Execution with GPU Distribution
# List to keep track of subprocess.Popen objects and method names
import subprocess
import os
import time

# List of available GPU IDs you want to use
available_gpus = [0, 1, 2, 3, 4, 5, 6, 7]  # adjust based on your machine

processes = []

for idx, (method, model_path) in enumerate(model_names.items()):
    gpu_id = available_gpus[idx % len(available_gpus)]  # round-robin allocation
    log_file = f"{method}_f.log"
    
    # Corrected command without nohup and &
    command = (
        f"CUDA_VISIBLE_DEVICES={gpu_id} "
        "python eval.py "
        "--config-name=eval.yaml "
        "experiment=eval/tofu/default "
        "model=Llama-3.2-1B-Instruct "
        f"model.model_args.pretrained_model_name_or_path={model_path} "
        "retain_logs_path=saves/eval/tofu_Llama-3.2-1B-Instruct_retain90/TOFU_EVAL.json "
        f"task_name={method} "
        f"> {log_file} 2>&1"
    )

    print(f"🚀 Launching '{method}' on GPU {gpu_id}.")
    print(f"    Command: {command}")

    # Launch the process
    # Use Popen without shell=True for better security and process control
    # Or keep shell=True if the command relies on shell features like redirection
    process = subprocess.Popen(command, shell=True) 
    processes.append((process, method, gpu_id))
    time.sleep(1)  # slight stagger to avoid overload

print("\n✅ All processes launched in parallel, distributed across GPUs.\n")

