export ALFRED_ROOT=$(pwd)

EPOCHS=(1_7884 1_2628)

for epoch in ${EPOCHS[@]}
do
	CUDA_VISIBLE_DEVICES=1 python models/eval/leaderboard.py			\
		--nav_model_path ../moca_panoramic_navonly_aug_finetune/exp/finetune_3_nav_aug/net_epoch_${epoch}.pth  \
		--pickup_model_path exp/PickupObject/net_epoch_48.pth  \
		--put_model_path exp/PutObject/net_epoch_49.pth  \
		--heat_model_path exp/HeatObject/net_epoch_30.pth  \
		--cool_model_path exp/CoolObject/net_epoch_49.pth  \
		--clean_model_path exp/CleanObject/net_epoch_49.pth  \
		--toggle_model_path exp/ToggleObject/net_epoch_34.pth  \
		--slice_model_path exp/SliceObject/net_epoch_36.pth  \
		--object_model_path exp/obj_pred/extraFC/net_epoch_3.pth  \
		--subgoal_model_path exp/subgoal_pred/net_epoch_5.pth  \
		--gpu                                               \
		--dout leaderboard_3_woGoBack_directManReturn_loop_break_scr0.3_logs_sep2_11_30am_$epoch								\
		--num_threads 4 \
		--logs "leaderboard_3_woGoBack_earlyManReturn_loop_break_scr0.3_logs_sep2_11_30am.txt"
done
# --model_path	"exp/moca_batch16_lr3_autoaug/net_epoch_${epoch}.pth"	\
